/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crossroads.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class FluidCoolingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;
    public final float maxTemp;
    public final float addedHeat;

    public FluidCoolingRecipeSerializer(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, float maxTemp, float addedHeat) {
        this(key, "", input, inputAmount, output, outputCount, maxTemp, addedHeat);
    }

    public FluidCoolingRecipeSerializer(ResourceLocation key, String group, Object input, int inputAmount, Object output, int outputCount, float maxTemp, float addedHeat) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.maxTemp = maxTemp;
        this.addedHeat = addedHeat;
    }

    @Override
    public JsonElement get() {
        if (this.input == Fluids.f_76191_ || this.inputAmount <= 0) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "crossroads:fluid_cooling");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        JsonObject ingJson = new JsonObject();
        if (this.input instanceof String || this.input instanceof ResourceLocation) {
            ingJson.addProperty("tag", this.input.toString());
        } else if (this.input instanceof Fluid) {
            ingJson.addProperty("fluid", ((Fluid)this.input).getRegistryName().toString());
        }
        json.add("input", (JsonElement)ingJson);
        json.addProperty("fluid_amount", (Number)this.inputAmount);
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("max_temp", (Number)Float.valueOf(this.maxTemp));
        json.addProperty("temp_change", (Number)Float.valueOf(this.addedHeat));
        return json;
    }
}

